package main

import "fmt"

func prefixer(prefix string) func(string) string {
	return func(body string) string {
		return prefix + " " + body
	}
}

func main() {
	helloPrefix := prefixer("Hello")
	fmt.Println(helloPrefix("Bob"))   // Powinien być wyświetlony komunikat "Hello Bob"
	fmt.Println(helloPrefix("Maria")) // Powinien być wyświetlony komunikat "Hello Maria"
}
